import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:zcart_delivery/config/config.dart';
import 'package:zcart_delivery/translations/locale_keys.g.dart';
import 'package:zcart_delivery/views/account/account_page.dart';
import 'package:zcart_delivery/views/dashboard/dashboard_page.dart';
import 'package:zcart_delivery/views/orders/search_order_page.dart';
import 'package:zcart_delivery/views/support/vendor_support_page.dart';
import 'package:easy_localization/easy_localization.dart';

class WrapperPage extends StatefulWidget {
  const WrapperPage({super.key});

  @override
  State<WrapperPage> createState() => _WrapperPageState();
}

class _WrapperPageState extends State<WrapperPage> {
  @override
  void initState() {
    super.initState();

    notificationPermission();

    // TODO: Update FCM token
    // FirebaseMessaging.instance.onTokenRefresh.listen((event) {
    //   final userId = FirebaseAuth.instance.currentUser!.uid;
    //   FCMtokenProvider.addFCMToken(userId, initToken: event);
    //   SBNotificationProvider.enableNotification(userId);
    // });

    // Listen to messages when the app is in the foreground
    FirebaseMessaging.onMessage.listen((RemoteMessage message) {
      print("onMessage: ${message.messageId}");
    });

    // Listen to messages when the app is in the background
    FirebaseMessaging.onMessageOpenedApp.listen((RemoteMessage message) {
      print("onMessageOpenedApp: ${message.messageId}");
    });

    // Listen to messages when the app is closed
    FirebaseMessaging.instance.getInitialMessage().then((message) {
      print("getInitialMessage: ${message?.messageId}");
    });
  }

  void notificationPermission() async {
    FirebaseMessaging messaging = FirebaseMessaging.instance;

    await messaging.requestPermission(
      alert: true,
      announcement: false,
      badge: true,
      carPlay: false,
      criticalAlert: false,
      provisional: true,
      sound: true,
    );
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        FocusScope.of(context).unfocus();
      },
      child: DefaultTabController(
        length: 4,
        initialIndex: 0,
        child: Scaffold(
          bottomNavigationBar: SafeArea(
            child: TabBar(
              labelColor: Colors.black87,
              unselectedLabelColor: Colors.black38,
              indicatorColor: MyConfig.primaryColor,
              indicatorSize: TabBarIndicatorSize.label,
              labelStyle: Theme.of(context).textTheme.bodySmall!.copyWith(
                    fontWeight: FontWeight.bold,
                  ),
              tabs: [
                Tab(
                  icon: const Icon(Icons.dashboard),
                  text: LocaleKeys.dashboard.tr(),
                ),
                Tab(
                  icon: const Icon(Icons.search),
                  text: LocaleKeys.search.tr(),
                ),
                Tab(
                  icon: const Icon(Icons.contact_support),
                  text: LocaleKeys.support.tr(),
                ),
                Tab(
                  icon: const Icon(Icons.account_circle_sharp),
                  text: LocaleKeys.account.tr(),
                ),
              ],
            ),
          ),
          body: const TabBarView(
            children: [
              DashboardPage(),
              SearchOrderPage(),
              VendorSupportPage(),
              AccountPage(),
            ],
          ),
        ),
      ),
    );
  }
}
